#define TVMODE 0
/********************************************************************************/
//                        |ATmega328P(uno,nano)|ATmega32u4|ESP8266|ATSAMD21(XIAO)
// TVMODE                 |   0   1   2   3   4|    0    1|     0	|   0   1
// -----------------------+--------------------+----------+-------+-------------
// I2C(LCD,MOTOR,TALK,...)|   o   o   o   x   x|    o    o|     o	|   o   o
// servo,Remocon,NeoPixel |   o   x   x   x   x|    o    x|     o |   o   o
// NUMLED                 |   o   x   x   x   x|    o    x|     x |   o   o
// video                  |   x   o   o   o   o|    x    o|     x |   x   o
// keyboard               |   x   x   o   x   o|    x    x|     x |   x   x
// max program size(Bytes)|1020 698 582 951 835| 1020 1020|  1020	|1020 1020
// RAM remaining(Bytes)   | 322 710 714 716 720|  850  932| 34944 |
/********************************************************************************/
// TinyBASIC.cpp : An implementation of TinyBASIC in C
// Original Author : Mike Field - hamster@snap.net.nz
// This Version: George Gray - halfbyteblog.wordpress.com
// Based on TinyBasic for 68000, by Gordon Brandly (see http://members.shaw.ca/gbrandly/68ktinyb.html)
// which itself was Derived from Palo Alto Tiny BASIC as  published in the May 1976 issue of Dr. Dobb's Journal.  
// 0.03 21/01/2011 : Added INPUT routine M
//                 : Reorganised memory layout
//                 : Expanded all error messages
//                 : Break key added
//                 : Removed the calls to printf (left by debugging)
//2013: began working on modifying for console-George Gray, HalfByte
//2014: heavily modified for HalfByte Console.
//added graphics statements
//added sound
//fixed POKE
//added SERIAL and PIN access
//added POLY and CROSSHAIRS
//Enhanced LIST
//added ARC to draw arcs, pie chart pieces
//20210909: modified by KOYAMA (see https://koyama.verse.jp/elecraft/avr/tinybasicxiao.html)

#if TVMODE==0										// ----TVMODE==0----------------------
#define I2C
#define PIXEL
#if defined(ESP8266)
#else
#define NUMLED
#endif
#define EESIZE 1022
#elif TVMODE==1									// ----TVMODE==1----------------------
#define I2C
#if defined(__SAMD21__)					// ----XIAO---------------------------
#define PIXEL
#define NUMLED
#endif													// -----------------------------------
#define VIDEO
#if defined(__AVR_ATmega32U4__)||defined(__SAMD21__)	// --ProMicro/XIAO--
#define EESIZE 1022
#else														// ----NANO/ESP8266-------------------
#define EESIZE 700
#endif													// -----------------------------------
#elif TVMODE==2									// ----TVMODE==2----------------------
#define I2C
#define VIDEO
#define KEYBOARD
#define EESIZE 584
#elif TVMODE==3									// ----TVMODE==3----------------------
#define VIDEO
#define EESIZE 953
#elif TVMODE==4									// ----TVMODE==4----------------------
#define VIDEO
#define KEYBOARD
#define EESIZE 837
#endif													// -----------------------------------
#define SCREEN_W	80
#define SCREEN_H	64
#ifdef I2C											// -----I2C---------------------------
//#define SHT		0x45						// ADR open
#define SHT			0x44						// ADR - GND
#define AQUEST	0x2E
#include <Wire.h>
#include <ST7032.h>
ST7032 lcd;
#endif													// -----------------------------------

#if defined(ESP8266)											// ----ESP8266--------------
#include <EEPROM.h>
#elif defined(__SAMD21__)									// ----XIAO-----------------
#include <FlashAsEEPROM.h>
#include <SavePowerXIAO.h>
SavePowerXIAO nrgSave;
#else																			// ----NANO/ProMicro--------
#include <EEPROM.h>
#include <avr/sleep.h>
#endif																		// -------------------------
#include <math.h>
#undef  PROGMEM
#define PROGMEM __attribute__((section(".progmem.vars")))

#if defined(VIDEO)												// ----VIDEO----------------
#if defined(__SAMD21__)										// ----XIAO-----------------
#include <Adafruit_GFX.h>									// 6x8 font
#include <Adafruit_CompositeVideo.h>
//#include <Fonts/TomThumb.h>
Adafruit_NTSC80x64 display;
#define BLACK	0
#define WHITE	255
#else																			// ----NANO/ProMicro--------
#include <font4x6.h>
#include <TVout.h>
TVout TV;
#endif																		// -------------------------
#endif																		// -------------------------

#if defined(PIXEL)												// ----NEOPIXEL-------------
#include <Servo.h>
#define TSERVO 500    // servo is automatically detached after 500ms
Servo myservo;
unsigned long servoMillis=0;

#include <Adafruit_NeoPixel.h>
#if defined(__AVR_ATmega32U4__)						// ----ProMicro-------------
#define NEO_PIN    4
#define NPIXEL     50
#elif defined(ESP8266)
#define NEO_PIN    15
#define NPIXEL     50
#elif defined(__SAMD21__)									// ----XIAO-----------------
#define NEO_PIN    10
#define NPIXEL     50
#else																			// ----NANO-----------------
#define NEO_PIN    17
#define NPIXEL     12
#endif
Adafruit_NeoPixel pixels=Adafruit_NeoPixel(NPIXEL, NEO_PIN, NEO_GRB+NEO_KHZ800);
#endif

#ifdef KEYBOARD
//#define USE_JP_KEYBOARD
#include <PS2Keyboard.h>
// PS/2 Keyboard
const int DataPin=2;			// PS/2 Keyboard (DATA)
const int IRQpin=3;				// PS/2 Keyboard (CLOCK)
PS2Keyboard keyboard;
#endif

#if defined(ESP8266)											// ----ESP8266--------------
#include <ESP8266WiFi.h>
//#include <WiFiClient.h> 
#include <WiFiUdp.h>
#include <NTPClient.h>
#include <TimeLib.h>
#include <WebSocketsServer.h>
#include <Hash.h>
#include <ESP8266WebServer.h>
#include <ESP8266mDNS.h>
#include "index.h"
//WiFiClient client;
WiFiUDP ntpUDP;
NTPClient timeClient(ntpUDP, "ntp.nict.jp", 32400, 86400000);  // UTC+9H, every 24H
MDNSResponder mdns;
ESP8266WebServer webServer(80);
WebSocketsServer   wsServer(81);
char wsbuf[500]="", *pws=wsbuf, TITLE[80]="tinyBasic8266", BUTTON[9][2][80], SLIDER[3][2][80];
bool ESCflag=false;
#endif																		// -------------------------

//int outswitch=true;
int stopFlag=false;
#ifndef ARDUINO														// -------------------------
#include "stdafx.h"
#include <conio.h>
#endif																		// -------------------------

// ASCII Characters
#define CR		'\r'
#define NL		'\n'
#define TAB		'\t'
#define BELL	'\b'
#define DEL		'\127'
#define BS		0x08
#define ESC		0x1B
#define SPACE	' '
#define CTRLC	0x19
#define CTRLH	0x7F
#define CTRLS	0x13
#define CTRLX	0x18

const double PI_180=0.017453278;

typedef short unsigned LINENUM;

/***********************************************************/
// Keyword table and constants - the last character has 0x80 added to it
#if defined(ESP8266)||defined(__SAMD21__)	// ----ESP8266/XIAO---------
static unsigned char keywords[]={
#else																			// ----NANO/ProMicro--------
const unsigned char keywords[] PROGMEM={
#endif																		// -------------------------
  'L','I','S','T'+0x80, 'L','O','A','D'+0x80, 'N','E','W'+0x80, 'R','U','N'+0x80,
  'S','A','V','E'+0x80, 'N','E','X','T'+0x80, 'L','E','T'+0x80,	 'I','F'+0x80, 'G','O','T','O'+0x80,
  'G','O','S','U','B'+0x80,	'R','E','T','U','R','N'+0x80,	'R','E','M'+0x80, 'F','O','R'+0x80,
  'I','N','P','U','T'+0x80,	'P','R','I','N','T'+0x80, 'P','O','K','E'+0x80, 'S','T','O','P'+0x80,
//  '@'+0x80,
  '?'+0x80, 'A','W','R','I','T','E'+0x80, 'D','W','R','I','T','E'+0x80,
  'M','E','M'+0x80, 'T','O','N','E'+0x80, 'D','E','L','A','Y','U','S'+0x80, 'D','E','L','A','Y'+0x80, 'C','L','E','A','R'+0x80, '#'+0x80,
#if defined(I2C)													// ----I2C-----------------
  'T','A','L','K'+0x80, 'M','O','T','O','R'+0x80,
#endif																		// ------------------------
  'C','L','S'+0x80, 'C','U','R','S','O','R'+0x80,
#if defined(VIDEO)												// ----VIDEO----------------
  'P','L','O','T'+0x80,	'B','M','P'+0x80,
  'B','O','X'+0x80, 'L','I','N','E'+0x80, 'C','I','R','C','L','E'+0x80, 'S','H','I','F','T'+0x80, 'I','N','V','E','R','T'+0x80,
#endif																		// -------------------------
#if defined(NUMLED)												// ----NUMLED---------------
  'N','U','M','L','E','D'+0x80,
#endif																		// -------------------------
#if defined(PIXEL)												// ----NEOPIXEL-------------
  'S','E','R','V','O'+0x80, 'P','I','X','E','L'+0x80,
  'F','3','8','K'+0x80, 'R','C','B','Y','T','E'+0x80, 'S','C','B','Y','T','E'+0x80,
#endif
#if defined(ESP8266)											// ----ESP8266--------------
  'T','I','T','L','E'+0x80, 'B','U','T','T','O','N'+0x80, 'S','L','I','D','E','R'+0x80, 'B','A','R'+0x80, 'W','I','F','I'+0x80,
#else																			// ----NANO/ProMicro/XIAO---
  'S','L','E','E','P'+0x80,
#endif																		// -------------------------
  0
};
enum {
  KW_LIST=0, KW_LOAD, KW_NEW, KW_RUN,
  KW_SAVE, KW_NEXT, KW_LET, KW_IF, KW_GOTO,
  KW_GOSUB, KW_RETURN, KW_REM, KW_FOR,
  KW_INPUT, KW_PRINT, KW_POKE, KW_STOP,
//  KW_AT,
  KW_QMARK, KW_AWRITE, KW_DWRITE,
  KW_MEM, KW_TONE, KW_DELAYUS, KW_DELAY, KW_CLEAR, KW_HASHTAG,
#if defined(I2C)													// ----I2C-----------------
  KW_TALK, KW_MOTOR,
#endif																		// ------------------------
  KW_CLS, KW_CURSOR,
#if defined(VIDEO)												// ----VIDEO----------------
  KW_PLOT, KW_BMP,
  KW_BOX, KW_LINE, KW_CIRCLE, KW_SHIFT, KW_INVERT,
#endif																		// -------------------------
#if defined(NUMLED)												// ----NUMLED---------------
  KW_NUMLED,
#endif																		// -------------------------
#if defined(PIXEL)												// ----NEOPIXEL-------------
  KW_SERVO, KW_PIXEL,
  KW_F38K, KW_RCBYTE, KW_SCBYTE,
#endif
#if defined(ESP8266)											// ----ESP8266--------------
  KW_TITLE, KW_BUTTON, KW_SLIDER, KW_BAR, KW_WIFI,
#else																			// ----NANO/ProMicro--------
  KW_SLEEP,
#endif																		// -------------------------
  KW_DEFAULT};

struct stack_for_frame{
  char frame_type, for_var;
  short int terminal, step;
  unsigned char *current_line, *txtpos;
} __attribute__ ((packed));								// not use padding

struct stack_gosub_frame{
  char frame_type;
  unsigned char *current_line, *txtpos;
} __attribute__ ((packed));								// not use padding

#if defined(ESP8266)||defined(__SAMD21__)	// ----ESP8266/XIAO---------
static unsigned char func_tab[]={
#else																			// ----NANO/ProMicro--------
const unsigned char func_tab[] PROGMEM={
#endif																		// -------------------------
  'P','E','E','K'+0x80, 'A','B','S'+0x80, 'R','N','D'+0x80, 'C','H','R'+0x80,
  '@'+0x80, 'M','E','M'+0x80, 'T','O','P'+0x80, 'A','R','E','A','D'+0x80,
  'D','R','E','A','D'+0x80, 'S','I','N'+0x80, 'C','O','S'+0x80,
  'T','E','M','P'+0x80, 'H','U','M','I'+0x80,
  'I','N','K','E','Y'+0x80, 'I','N'+0x80, 'G','E','T'+0x80,
#if defined(ESP8266)											// ----ESP8266--------------
  'Y','E','A','R'+0x80, 'M','O','N','T','H'+0x80, 'D','A','Y'+0x80,
  'H','O','U','R'+0x80, 'M','I','N','U','T','E'+0x80, 'S','E','C','O','N','D'+0x80,
#endif																		// -------------------------
  0
};

#define FUNC_PEEK  	0
#define FUNC_ABS  	1
#define FUNC_RND    2
#define FUNC_CHR    3
#define FUNC_AT	    4
#define FUNC_MEM    5
#define FUNC_TOP    6
#define FUNC_AREAD  7
#define FUNC_DREAD  8
#define FUNC_SIN    9
#define FUNC_COS    10
#define FUNC_TEMP   11
#define FUNC_HUMI   12
#define FUNC_INKEY	13
#define FUNC_UARTIN	14
#define FUNC_GET    15
#if defined(ESP8266)											// ----ESP8266--------------
#define FUNC_YEAR   16
#define FUNC_MONTH  17
#define FUNC_DAY    18
#define FUNC_HOUR   19
#define FUNC_MINUTE 20
#define FUNC_SECOND 21
#define FUNC_UNKNOWN 22
#else																			// ----NANO/ProMicro/XIAO---
#define FUNC_UNKNOWN 16
#endif																		// -------------------------
#if defined(ESP8266)||defined(__SAMD21__)	// ----ESP8266/XIAO---------
static unsigned char to_tab[]={
#else																			// ----NANO/ProMicro--------
const unsigned char to_tab[] PROGMEM={
#endif																		// -------------------------
  'T','O'+0x80, 0
};

#if defined(ESP8266)||defined(__SAMD21__)	// ----ESP8266/XIAO---------
static unsigned char step_tab[]={
#else																			// ----NANO/ProMicro--------
const unsigned char step_tab[] PROGMEM={
#endif																		// -------------------------
  'S','T','E','P'+0x80, 0
};

#if defined(ESP8266)||defined(__SAMD21__)	// ----ESP8266/XIAO---------
static unsigned char relop_tab[]={
#else																			// ----NANO/ProMicro--------
const unsigned char relop_tab[] PROGMEM={
#endif																		// -------------------------
  '>','='+0x80, '<','>'+0x80, '>'+0x80, '='+0x80, '<','='+0x80, '<'+0x80, '!','='+0x80, 0
};

#define RELOP_GE		0
#define RELOP_NE		1
#define RELOP_GT		2
#define RELOP_EQ		3
#define RELOP_LE		4
#define RELOP_LT		5
#define RELOP_NEX		6
#define RELOP_UNKNOWN	7

#if defined(ESP8266)||defined(__SAMD21__)	// ----ESP8266/XIAO---------
static unsigned char highlow_tab[]={
#else																			// ----NANO/ProMicro--------
const unsigned char highlow_tab[] PROGMEM={
#endif																		// -------------------------
  'H','I','G','H'+0x80,	'H','I'+0x80, 'L','O','W'+0x80, 'L','O'+0x80, 0
};

#define HIGHLOW_HIGH    1
#define HIGHLOW_UNKNOWN 4
#define STACK_SIZE (sizeof(struct stack_for_frame)*5)
#define VAR_SIZE sizeof(short int) // Size of variables in bytes
//memory            |------------------------------|
//variables_table-> |(variable area: 27*VAR_SIZE)  |
//                  | A(2 bytes)                   |
//                  | B(2 bytes)                   |
//                  | ...                          |
//                  |                              |
//                  |------------------------------|
//program_start  -> |(program area: EESIZE-2 bytes)|
//                  |  10(line_number: 2 bytes)    |
//                  |  4(line_length: 1 byte)      |
//                  |  'A'                         |
//                  |  '='                         |
//                  |  '1'                         |
//                  |  '\n'                        |
//                  |  ...                         |
//program_end    -> |   LINENUM(2 bytes)           |
//txtpos         -> |                              |
//                  |                              |
//                  |(memory remaining =           |
//                  |   stack_limit-program_end)   |
//                  |------------------------------|
//stack_limit   ->  |   (STACK_SIZE)               |
//                  |                              |
//                  |------------------------------|
//spt            -> |                              |

static unsigned char memory[EESIZE-2+27*VAR_SIZE+STACK_SIZE];
#if defined(ESP8266)||defined(__SAMD21__)	// ----ESP8266/XIAO---------
static short int atbuf[1024];
#endif																		// -------------------------
static unsigned char *variables_table;
static unsigned char *program_start;
static unsigned char *program_end;
static unsigned char *txtpos;
static unsigned char *stack_limit;
static unsigned char *spt;
static unsigned char *current_line;
static unsigned char *list_line, expression_error, *tempsp;
static unsigned char *stack;	// Software stack for things that should go on the CPU stack
static unsigned char table_index;
#define STACK_GOSUB_FLAG 'G'
#define STACK_FOR_FLAG 'F'
#if defined(__AVR_ATmega32U4__)						// ----ProMicro-------------
static unsigned char tonePin=255;
char SerialFlag;  // 0 if Serial connected
//static bool SerialFlag=false;
#endif																		// -------------------------
static LINENUM linenum;
#if defined(ESP8266)||defined(__SAMD21__)	// ----ESP8266/XIAO---------
static const unsigned char okmsg[]            = "Ready";
static const unsigned char badlinemsg[]       = "Bad line #";
static const unsigned char invalidexprmsg[]   = "Expr error";
static const unsigned char syntaxmsg[]        = "Syntax error";
static const unsigned char badinputmsg[]      = "\nBad Number";
static const unsigned char nomemmsg[]         = "No memory!";
static const unsigned char initmsg[]          = "HalfByte TinyBasic";
static const unsigned char memorymsg[]        = " bytes free.";
static const unsigned char breakmsg[]         = "Break!";
static const unsigned char stackstuffedmsg[]  = "Stack!\n";
static const unsigned char unimplimentedmsg[] = "Not yet";
static const unsigned char backspacemsg[]     = "\b \b";
static const unsigned char hitkeymsg[]        = "Hit any key!";
static const unsigned char autorunmsg[]       = "Program is running...";
#else																			// ----NANO/ProMicro--------
const unsigned char okmsg[]            PROGMEM= "Ready";
const unsigned char badlinemsg[]       PROGMEM= "Bad line #";
const unsigned char invalidexprmsg[]   PROGMEM= "Expr error";
const unsigned char syntaxmsg[]        PROGMEM= "Syntax error";
const unsigned char badinputmsg[]      PROGMEM= "\nBad Number";
const unsigned char nomemmsg[]         PROGMEM= "No memory!";
const unsigned char initmsg[]          PROGMEM= "HalfByte TinyBasic";
const unsigned char memorymsg[]        PROGMEM= " bytes free.";
const unsigned char breakmsg[]         PROGMEM= "Break!";
const unsigned char stackstuffedmsg[]  PROGMEM= "Stack!\n";
const unsigned char unimplimentedmsg[] PROGMEM= "Not yet";
const unsigned char backspacemsg[]     PROGMEM= "\b \b";
const unsigned char hitkeymsg[]        PROGMEM= "Hit any key!";
const unsigned char autorunmsg[]       PROGMEM= "Program is running...";
#endif																		// -------------------------
static int inchar(void);
static void outchar(unsigned char c);
static void line_terminator(void);
static short int expression(void);
static unsigned char breakcheck(void);
/***************************************************************************/
static void ignore_blanks(void){ while(*txtpos==SPACE || *txtpos==TAB)  txtpos++; }
/***************************************************************************/
static void scantable(unsigned char *table){
  int i=0;
  ignore_blanks();
  table_index=0;
  while(1){
    if(pgm_read_byte(table)==0)  return;	// Run out of table entries?
    if(txtpos[i]==pgm_read_byte(table)){	// Do we match this character?
      i++;	table++;
    }else{	// do we match the last character of keywork (with 0x80 added)? If so, return
      if(txtpos[i]+0x80==pgm_read_byte(table)){
        txtpos += i+1;  // Advance the pointer to following the keyword
        ignore_blanks();
        return;
      }
      // Forward to the end of this keyword
      while((pgm_read_byte(table) & 0x80)==0)  table++;
      // Now move on to the first character of the next word, and reset the position index
      table++;	table_index++;
      i=0;
    }
  }
}
/***************************************************************************/
static void pushb(unsigned char b){	spt--;	*spt=b;	}
static unsigned char popb(){ unsigned char b=*spt; spt++; return b;}
/***************************************************************************/
static void printnum(int num){
  int digits=0;
  if(num<0){	num=-num;	outchar('-');	}
  do{ pushb(num%10+'0'); num=num/10; digits++; }while(num>0);
  for(; digits>0; digits--) outchar(popb());
}
/***************************************************************************/
static unsigned short testnum(void){			// return line number
  unsigned short num=0;
  ignore_blanks();
  for(;*txtpos>='0' && *txtpos<='9'; txtpos++){
    if(num>=0xFFFF/10){	num=0xFFFF;	break;	}	// Trap overflows
    num=num*10+*txtpos-'0';
  }
  return	num;
}
/***************************************************************************/
unsigned char check_statement_end(void){ ignore_blanks(); return (*txtpos==NL) || (*txtpos==':');}
/***************************************************************************/
void printmsgNoNL(const unsigned char *msg){ while(pgm_read_byte(msg)!=0)  outchar(pgm_read_byte(msg++));}
/***************************************************************************/
static unsigned char print_quoted_string(void){
  unsigned char delim=*txtpos;
  if(delim!='"' && delim!='\'')  return 0;
  txtpos++;
  for(int i=0;txtpos[i]!=delim;i++) if(txtpos[i]==NL) return 0;// Check we have a closing delimiter
  for(;*txtpos!=delim; txtpos++) outchar(*txtpos);	// Print the characters
  txtpos++; ignore_blanks();						// Skip over the last delimiter
  return 1;
}
/***************************************************************************/
#if defined(I2C)													// ----I2C-----------------
static void talknum(int num){
  char buf[50]="", *p=buf;
  int digits=0;
  if(num<0){ num=-num; strcat(buf, "mainasu"); p+=7; }
  strcat(buf, "<NUMK VAL="); p+=10;
  do{ pushb(num%10+'0'); num=num/10; digits++; }while(num>0);
  for(; digits>0; digits--) *p++=popb();
  *p++='>'; *p++='\r'; *p='\0';
  Wire.beginTransmission(AQUEST); Wire.write(buf); Wire.endTransmission();
  while(1){
    Wire.requestFrom(AQUEST, 1);
    if(Wire.read()=='>') break;
    delay(10);
  }
}
/***************************************************************************/
static unsigned char talk_quoted_string(void){
  char buf[50]="", *p=buf;
  unsigned char delim=*txtpos;
  if(delim!='"') return 0;
  txtpos++;
  for(int i=0;txtpos[i]!=delim;i++) if(txtpos[i]==NL) return 0;// Check we have a closing delimiter
  for(;*txtpos!=delim; txtpos++) *p++ = *txtpos;  // talk the characters
  *p++='\r'; *p='\0';
  Wire.beginTransmission(AQUEST); Wire.write(buf); Wire.endTransmission();
  while(1){
    Wire.requestFrom(AQUEST, 1);
    if(Wire.read()=='>') break;
    delay(10);
  }
  txtpos++; ignore_blanks();            // Skip over the last delimiter
  return 1;
}
#endif																		// -------------------------
/***************************************************************************/
static void printmsg(const unsigned char *msg){	printmsgNoNL(msg);	line_terminator();	}
/***************************************************************************/
unsigned char getln(char prompt){
  outchar(prompt);
  txtpos=program_end+sizeof(LINENUM);
  while(1){
    char c=inchar();
    switch(c){
    case CR:
    case NL:
      line_terminator();
      txtpos[0]=NL;		// Terminate all strings with a NL
      return 1;
    case CTRLC:	return 0;
    case BS:
    case CTRLH:
      if(txtpos==program_end)  break;
      txtpos--;
      printmsgNoNL(backspacemsg);
      break;
    default:
      // We need to leave at least one space to allow us to shuffle the line into order
      if(txtpos==spt-2)	outchar(BELL);
      else{txtpos[0]=c;	txtpos++;	outchar(c); }
    }
  }
}
/***************************************************************************/
static unsigned char *findline(void){
  unsigned char *line=program_start;
  while(1){
    if(line==program_end)  return line;
#if defined(ESP8266)||defined(__SAMD21__)	// ----ESP8266/XIAO---------
    if(*line+(*(line+1)<<8)>=linenum) return line;  // modified for ESP8266
#else																			// ----NANO/ProMicro--------
    if(((LINENUM *)line)[0]>=linenum)  return line;
#endif																		// -------------------------
    // Add the line length onto the current address, to get to the next line;
    line+=line[sizeof(LINENUM)];
  }
}
/***************************************************************************/
static void toUppercaseBuffer(void){
  unsigned char *c=program_end+sizeof(LINENUM);
  unsigned char quote=0;
  while(*c!=NL){
    if(*c==quote)  quote=0;    // Are we in a quoted string?
    else if(quote==0 && (*c=='"' || *c=='\''))  quote=*c; // "..'..'.." is available
    else if(quote==0 && *c>='a' && *c<='z')  *c=*c+'A'-'a';
    c++;
  }
}
/***************************************************************************/
#ifdef ESP8266
void sendlist(){
  unsigned char *p=program_start;
  String str="list:";
  while(p!=program_end){
    LINENUM line_num;
    line_num=*p+(*(p+1)<<8);  // modified for ESP8266
    p+=sizeof(LINENUM)+sizeof(char);
    str+=line_num; str+=' ';
    while(*p!=NL){ str+=(char)*p; p++; }
    p++;
    str+='\n';
  }
  Serial.println(str);
  int strlen=str.length();
  char charstr[strlen+1]; str.toCharArray(charstr, strlen+1);
  wsServer.broadcastTXT(charstr, strlen);
}
#endif
/***************************************************************************/
void printline(){
  LINENUM line_num;
#if defined(ESP8266)||defined(__SAMD21__)	// ----ESP8266/XIAO---------
  line_num=*list_line+(*(list_line+1)<<8);  // modified for ESP8266
#else																			// ----NANO/ProMicro--------
  line_num=*((LINENUM *)(list_line));
#endif																		// -------------------------
  list_line+=sizeof(LINENUM)+sizeof(char);
  printnum(line_num);  // Output the line
  outchar(' ');
  while(*list_line!=NL){  outchar(*list_line);  list_line++; }
  list_line++;
  line_terminator();
}
/***************************************************************************/
static short int expr4(void){
  short int a=0, b=0;
  // fix provided by Jurg Wullschleger wullschleger@gmail.com
  ignore_blanks();	// fixes whitespace and unary operations
  if(*txtpos=='-'){  txtpos++; return -expr4();  }
  if(*txtpos=='!'){  txtpos++; return !expr4();  }
  if(*txtpos=='#' || *txtpos=='$' || *txtpos=='&'){
    txtpos++;
    for(;;){
      short int t;
      if(*txtpos>='0' && *txtpos<='9')      t=*txtpos-'0';
      else if(*txtpos>='A' && *txtpos<='F') t=*txtpos-'A'+10;
      else if(*txtpos>='a' && *txtpos<='f') t=*txtpos-'a'+10;
      else break;
      a=a*16+t;
      txtpos++;
    }
    goto success;
  }
  if(*txtpos=='0'){	txtpos++;	a=0;	goto success;	}	// end fix
  if(*txtpos>='1' && *txtpos<='9'){
    do{	a=a*10+*txtpos-'0';	txtpos++; }while(*txtpos>='0' && *txtpos<='9');
    goto success;
  }
  if(*txtpos=='\'' && *(txtpos+2)=='\''){ a=*(++txtpos); txtpos+=2; goto success;}
  scantable(highlow_tab);
  if(table_index!=HIGHLOW_UNKNOWN){
    a=(table_index<=HIGHLOW_HIGH)?1:0;
    goto success;
  }
//***************************
  if(*txtpos=='@'){										// Array
    txtpos++;
    if(*txtpos!='(') goto expr4_error;
    txtpos++;
    if(*txtpos!=')'){
      a=expression();
      ignore_blanks;  if(*txtpos!=')')  goto expr4_error;
    }else a=0;
    txtpos++;
#if defined(ESP8266)||defined(__SAMD21__)	// ----ESP8266/XIAO---------
    return *(atbuf+a);
#else																			// ----NANO/ProMicro--------
    return *((short int *)program_end+a);
#endif																		// -------------------------
  }else
//***************************
  if(txtpos[0]>='A' && txtpos[0]<='Z'){  // Is it a function or variable reference?
#if defined(ESP8266)||defined(__SAMD21__)	// ----ESP8266/XIAO---------
    if(!(txtpos[1]>='A' && txtpos[1]<='Z' || txtpos[1]>='0' && txtpos[1]<='9')){  // Is it a variable reference
#else																			// ----NANO/ProMicro--------
    if(txtpos[1]<'A' || txtpos[1]>'Z'){	// Is it a variable reference (single alpha)
#endif																		// -------------------------
      a=((short int *)variables_table)[*txtpos-'A'];
      txtpos++;
      return a;
    }
    // Is it a function with a single parameter
    scantable(func_tab);
    if(table_index==FUNC_UNKNOWN)  goto expr4_error;
    unsigned char f=table_index;
    if(*txtpos!='(')	goto expr4_error;
    txtpos++;
    if(*txtpos!=')'){
      a=expression();
      ignore_blanks();
      if(*txtpos!=','){    // check for a comma
        ignore_blanks;	if(*txtpos!=')')  goto expr4_error;
      }else{
        txtpos++; b=expression();
        ignore_blanks;	if(*txtpos!=')')  goto expr4_error;
      }
    }else a=b=0;
    txtpos++;
    switch(f){
    case FUNC_AT:
#if defined(ESP8266)||defined(__SAMD21__)	// ----ESP8266/XIAO---------
										return atbuf[a];
#endif																		// -------------------------
    case FUNC_PEEK:
#if defined(ESP8266)||defined(__SAMD21__)	// ----ESP8266/XIAO---------
										return *((unsigned char *)atbuf+a);
#else																			// ----NANO/ProMicro--------
										return memory[a];
#endif																		// -------------------------
    case FUNC_ABS:	return (a>=0? a: -a);
    case FUNC_RND:
      int tempR;
      tempR=random(a);      // generate random number between 0 and x
	    return (tempR>=0? tempR: -tempR);
    case FUNC_TOP:
#if defined(ESP8266)||defined(__SAMD21__)	// ----ESP8266/XIAO---------
      return a;
#else																			// ----NANO/ProMicro--------
      return (short int)program_end+a;
#endif																		// -------------------------
    case FUNC_CHR:			// output ascii
        if(a<256){	outchar(a);	expression_error=15;	}
        goto success;
    case FUNC_AREAD:
#if defined(ESP8266)											// ----ESP8266--------------
#elif defined(__SAMD21__)									// ----XIAO-----------------
#else																			// ----NANO/ProMicro--------
				analogReference(DEFAULT);
#endif																		// -------------------------
				pinMode(a, INPUT);	return analogRead(a);
    case FUNC_DREAD:{
				pinMode(a, INPUT_PULLUP);
#if defined(ESP8266)											// ----ESP8266--------------
      int val=digitalRead(a);
      char s[12]="D";
      itoa(a, s+1, 10);
      strcat(s, ":");
      itoa(val, s+strlen(s), 10);
      wsServer.broadcastTXT(s, strlen(s)); // send data to all connected clients
      return val;
    }
#else																			// ----NANO/ProMicro/XIAO---
      return digitalRead(a);
    }
#endif																		// -------------------------
#if defined(I2C)													// ----I2C-----------------
    case FUNC_TEMP:{    // SHT31 temperature
        Wire.beginTransmission(SHT); Wire.write(0x24); Wire.write(0x00); Wire.endTransmission();
        delay(15);
        Wire.requestFrom(SHT, 6);
        if(Wire.available()!=6)	return 0;				// Error
        uint16_t t=Wire.read(); t=(t<<8)|Wire.read(); Wire.read();	// read temperature
        Wire.read(); Wire.read(); Wire.read();	// skip
        return (((t>>8)*175)>>8)-45;
    }
    case FUNC_HUMI:{    // SHT31 humidity
        Wire.beginTransmission(SHT); Wire.write(0x24); Wire.write(0x00); Wire.endTransmission();
        delay(15);
        Wire.requestFrom(SHT, 6);
        if(Wire.available()!=6)	return 0;				// Error
        Wire.read(); Wire.read(); Wire.read();	// skip
        uint16_t h=Wire.read(); h=(h<<8)|Wire.read(); Wire.read();	// read humidity
        return ((h>>8)*100)>>8;
    }
#endif
#ifdef ESP8266
    case FUNC_YEAR: return year();
    case FUNC_MONTH:return month();
    case FUNC_DAY:  return day();
    case FUNC_HOUR:   return hour();
    case FUNC_MINUTE: return minute();
    case FUNC_SECOND: return second();
#endif
    case FUNC_MEM:	return stack_limit-program_end;		// Return memory remaining
    case FUNC_SIN:	return sin(a*PI_180)*1000;	// returns (value*10^3) for integer eval
    case FUNC_COS:	return cos(a*PI_180)*1000;	// returns (value*10^3) for integer eval
#ifdef KEYBOARD
    case FUNC_INKEY:return (char)keyboard.read();// grab a key from keyboard, if there
#endif
    case FUNC_UARTIN:{
      unsigned char c=inchar();
      if(c==ESC) return -1;  // breakcheck!
      else       return c;
    }
#if defined(VIDEO)												// ----VIDEO----------------
		case FUNC_GET:	
#if defined(__SAMD21__)										// ----XIAO-----------------
			return (display.getPixel(a,b)?1:0);
#else																			// -------------------------
			return TV.get_pixel(a,b);
#endif																		// -------------------------
#endif																		// -------------------------
    }
  }
  if(*txtpos=='('){
    txtpos++; a=expression();	if(*txtpos!=')')  goto expr4_error;
    txtpos++; goto success;
  }
expr4_error:	expression_error=1;
success:		ignore_blanks();	return a;
}
/***************************************************************************/
static short int expr3(void){
  short int a, b;
  a=expr4();
  while(1){
    if(*txtpos=='*'){	  txtpos++;	b=expr4(); a*=b;}
    else if(*txtpos=='/'){txtpos++;	b=expr4(); if(b!=0) a/=b; else expression_error=1;}
    else if(*txtpos=='%'){txtpos++; b=expr4(); if(b!=0) a%=b; else expression_error=1;}
    else if(*txtpos=='&'){txtpos++;	b=expr4(); if(b!=0) a&=b; else expression_error=1;}
    else if(*txtpos=='|'){txtpos++;	b=expr4(); if(b!=0) a|=b; else expression_error=1;}
    else if(*txtpos=='^'){txtpos++;	b=expr4(); if(b!=0) return pow(a,b);}
    else  return a;
  }
}
/***************************************************************************/
static short int expr2(void){
  short int a, b;
  if(*txtpos=='-' || *txtpos=='+') a=0;
  else                             a=expr3();
  while(1){
    if(*txtpos=='-'){     txtpos++; b=expr3(); a-=b;}
    else if(*txtpos=='+'){txtpos++; b=expr3(); a+=b;}
    else  return a;
  }
}
/***************************************************************************/
static short int expression(void){
  short int a, b;
  a=expr2();
  if(expression_error)	return a;
  scantable(relop_tab);
  if(table_index==RELOP_UNKNOWN)  return a;
  switch(table_index){
	case RELOP_GE:	b=expr2();	if(a>=b) return 1;	break;
	case RELOP_NEX:
	case RELOP_NE:	b=expr2();	if(a!=b) return 1;	break;
	case RELOP_GT:	b=expr2();	if(a>b)  return 1;	break;
	case RELOP_EQ:	b=expr2();	if(a==b) return 1;	break;
	case RELOP_LE:	b=expr2();	if(a<=b) return 1;	break;
	case RELOP_LT:	b=expr2();	if(a<b)  return 1;	break;
  }
  return 0;
}
/***************************************************************************/
void loop(){
  unsigned char *start, *newEnd, linelen;
  int clr_count;
  boolean isDigital;
  variables_table=memory;
  program_start=memory + 27*VAR_SIZE;
  program_end=program_start;
  spt=memory+sizeof(memory);
  stack_limit=spt-STACK_SIZE;
  printmsg(initmsg);
#if defined(ESP8266)						// ----ESP8266--------------
  if(millis()%1000==0 && timeClient.update()) setTime(timeClient.getEpochTime());  // NTP sync
#endif													// -------------------------
  {								// Auto load
  int size=(EEPROM.read(EESIZE-2))+(EEPROM.read(EESIZE-1)<<8);
    if(size<=EESIZE-2){
      program_end=program_start+size;
      for(int i=0; i<size; i++)	memory[i+27*VAR_SIZE]=EEPROM.read(i);
    }
  }
  printnum(stack_limit-program_end); printmsg(memorymsg);
  printmsg(hitkeymsg);
  for(int i=0; i<100; i++){		// Auto run after 3sec 
#ifdef __AVR_ATmega32U4__
    if(SerialFlag>0 && ++SerialFlag==100){
      if(Serial)  SerialFlag=0;  // Serial connected
      else        SerialFlag=1;
    }
    if(SerialFlag==0 && Serial.available()){ Serial.read();  goto warmstart;}
#else
    if(Serial.available()){ Serial.read();  goto warmstart;}
#endif
#ifdef KEYBOARD
	  else if(keyboard.available()){ keyboard.read();	goto warmstart;}
#endif
	  delay(30);
  }
  printmsg(autorunmsg);
  current_line=program_start;	goto execline;

warmstart:  // this signifies that it is running in 'direct' mode.
  current_line=0;
  spt=memory+sizeof(memory);
  printmsg(okmsg);
prompt:
  while(!getln('>'))  line_terminator();
  toUppercaseBuffer();
  txtpos=program_end+sizeof(unsigned short);
  while(*txtpos!=NL) txtpos++;  // Find the end of the freshly entered line
  {								// Move it to the end of program_memory
    unsigned char *dest;
    for(dest=spt-1; ; dest--){
      *dest=*txtpos;
      if(txtpos==program_end+sizeof(unsigned short))  break;
      txtpos--;
    }
    txtpos=dest;
  }
  // Now see if we have a line number
  linenum=testnum();
  ignore_blanks(); if(linenum==0) goto direct;
  if(linenum==0xFFFF) goto badline;
  // Find the length of what is left, including the (yet-to-be-populated) line header
  for(linelen=0; txtpos[linelen]!=NL; linelen++);
  linelen++; // Include the NL in the line length
  linelen+=sizeof(unsigned short)+sizeof(char); // Add space for the line number and line length
  // Now we have the number, add the line header.
  txtpos-=3;
#if defined(ESP8266)||defined(__SAMD21__)	// ----ESP8266/XIAO---------
  *txtpos=linenum&0xff;  *(txtpos+1)=(linenum>>8);  // modified for ESP8266
#else																			// ----NANO/ProMicro--------
  *((unsigned short *)txtpos)=linenum;
#endif																		// -------------------------
  txtpos[sizeof(LINENUM)]=linelen;
  // Merge it into the rest of the program
  start=findline();
  // If a line with that number exists, then remove it
#if defined(ESP8266)||defined(__SAMD21__)	// ----ESP8266/XIAO---------
  if(start!=program_end && *start+(*(start+1)<<8)==linenum){ // modified for ESP8266
#else																			// ----NANO/ProMicro--------
  if(start!=program_end && *((LINENUM *)start)==linenum){
#endif																		// -------------------------
    unsigned char *dest, *from;
    unsigned tomove;
    from=start+start[sizeof(LINENUM)];
    dest=start;
    for(tomove=program_end-from; tomove>0; tomove--){ *dest=*from;	from++;	dest++; }
    program_end=dest;
  }
  if(txtpos[sizeof(LINENUM)+sizeof(char)]==NL) goto prompt;	// If the line has no txt, it was just a delete
  // Make room for the new line, either all in one hit or lots of little shuffles
  while(linelen>0){	
    unsigned int tomove;
    unsigned char *from,*dest;
    unsigned int space_to_make=txtpos-program_end;
    if(space_to_make>linelen)  space_to_make=linelen;
    newEnd=program_end+space_to_make;
    // Source and destination - as these areas may overlap we need to move bottom up
    from=program_end;	dest=newEnd;
    for(tomove=program_end-start; tomove>0; tomove--){ from--;	dest--;	*dest=*from;}
    // Copy over the bytes into the new space
    for(tomove=0; tomove<space_to_make; tomove++){ *start=*txtpos; txtpos++; start++; linelen--;}
    program_end=newEnd;
  }
  goto prompt;
unimplemented: printmsg(unimplimentedmsg); goto prompt;
badline:       printmsg(badlinemsg);       goto prompt;
invalidexpr:   printmsg(invalidexprmsg);   goto prompt;
syntaxerror:
  printmsg(syntaxmsg);
  if(current_line!=(void *)0){
    unsigned char tmp=*txtpos;
    if(*txtpos!=NL)  *txtpos='^';
    list_line=current_line;
    printline();
    *txtpos=tmp;
  }
  line_terminator();
  goto prompt;
stackstuffed:	printmsg(stackstuffedmsg);	goto warmstart;
nomem:			printmsg(nomemmsg);			goto warmstart;
run_next_statement:
  if(breakcheck()){	printmsg(breakmsg);	goto warmstart;	}
  while(*txtpos==':')    txtpos++;
  ignore_blanks();	if(*txtpos==NL)  goto execnextline;
  goto interperateAtTxtpos;
direct: 
  txtpos=program_end+sizeof(LINENUM);
  if(*txtpos==NL)  goto prompt;
interperateAtTxtpos:
  if(breakcheck()){	printmsg(breakmsg);	goto warmstart;	}
  scantable(keywords);
  ignore_blanks();
  switch(table_index){
      case KW_LIST:	goto list;
      case KW_LOAD:	goto eLoad;
      case KW_NEW:
        if(txtpos[0]!=NL)  goto syntaxerror;
        program_end=program_start;
        goto run_next_statement;
//        goto prompt;
      case KW_RUN:
				current_line=program_start;
#ifdef ESC8266
				ESCflag=false;
#endif
				goto execline;
      case KW_SAVE:	goto eSave;
      case KW_NEXT:	goto next;
      case KW_LET:	goto assignment;
      case KW_IF:{
          short int val;
          expression_error=0;
          val=expression();
          if(expression_error || *txtpos==NL)  goto invalidexpr;
          if(val!=0)   goto interperateAtTxtpos;
          goto execnextline;
        }
      case KW_GOTO:
        expression_error=0;
        linenum=expression(); if(expression_error || *txtpos != NL)  goto invalidexpr;
        current_line=findline();
        goto execline;
      case KW_GOSUB:	goto gosub;
      case KW_RETURN:	goto gosub_return;
      case KW_HASHTAG:
      case KW_REM:		goto execnextline;	// Ignore line completely
      case KW_FOR:		goto forloop;
      case KW_INPUT:	goto input;
      case KW_QMARK:
      case KW_PRINT:	goto print;
//      case KW_AT:
      case KW_POKE:		goto poke;
      case KW_STOP: // This is the easy way to end - set the current line to the end of program attempt to run it
        if(txtpos[0]!=NL)  goto syntaxerror;
        current_line=program_end;
        goto execline;
      case KW_AWRITE:	isDigital=false;goto awrite;
      case KW_DWRITE:	isDigital=true;	goto dwrite;
      case KW_MEM:		goto mem;
      case KW_TONE:		goto mTone;
      case KW_DELAY:
        delay(expression());
        goto run_next_statement;
      case KW_DELAYUS:
        delayMicroseconds(expression());
        goto run_next_statement;
      case KW_CLEAR:
        for(clr_count=0; clr_count<27*VAR_SIZE; clr_count++)	memory[(int)clr_count]=0;
        goto run_next_statement;
#if defined(I2C)													// ----I2C-----------------
      case KW_MOTOR:  goto motor;
      case KW_TALK:   goto talk;
#endif																		// ------------------------
#if defined(ESP8266)											// ----ESP8266-------------
#else																			// ----NANO/ProMicro/XIAO--
      case KW_SLEEP:  goto sleep;
#endif																		// ------------------------
      case KW_CLS:    goto cls;
      case KW_CURSOR: goto setcursor;
#if defined(VIDEO)												// ----VIDEO----------------
      case KW_PLOT:		goto plot;
      case KW_BMP:		goto bmp;
      case KW_BOX:		goto box;
      case KW_LINE:		goto line;
      case KW_CIRCLE:	goto circle;
      case KW_SHIFT:	goto shiftscreen;
      case KW_INVERT:
#if defined(__SAMD21__)										// ----XIAO-----------------
#else																			// -------------------------
				TV.invert();
#endif																		// -------------------------
				goto execnextline;
#else																			// -------------------------
#if defined(NUMLED)												// ----NUMLED---------------
      case KW_NUMLED:	goto numled;
#endif																		// -------------------------
#endif																		// -------------------------
#if defined(PIXEL)												// ----NEOPIXEL-------------
      case KW_SERVO:  goto servo;
      case KW_F38K:   goto f38k;
      case KW_RCBYTE: goto rcbyte;
      case KW_SCBYTE: goto scbyte;
      case KW_PIXEL:	goto pixel;
#endif																		// -------------------------
#if defined(ESP8266)											// ----ESP8266--------------
      case KW_WIFI:   goto wifi;
      case KW_TITLE:  goto title;
      case KW_BUTTON: goto button;
      case KW_SLIDER: goto slider;
      case KW_BAR:    goto bar;
#endif																		// -------------------------
      case KW_DEFAULT:	goto assignment;
      default:			break;
      }
execnextline:
  if(current_line==(void *)0)	  goto prompt;	// Processing direct commands?
  current_line += current_line[sizeof(LINENUM)];
execline:
  if(current_line == program_end) goto warmstart; // Out of lines to run
  txtpos=current_line+sizeof(LINENUM)+sizeof(char);
  goto interperateAtTxtpos;
input:{
    unsigned char isneg=0, *temptxtpos;
    short int *var;
    ignore_blanks();	if(*txtpos<'A' || *txtpos>'Z')  goto syntaxerror;
    var=((short int *)variables_table)+*txtpos-'A';
    txtpos++;	if(!check_statement_end())	goto syntaxerror;
again:
    temptxtpos=txtpos;
    if(!getln('?'))  goto warmstart;
    txtpos=program_end+sizeof(LINENUM);    // Go to where the buffer is read
    if(*txtpos=='-'){	isneg=1;	txtpos++;	}
    *var=0;
    do{	*var=*var*10+*txtpos-'0';	txtpos++; }while(*txtpos>='0' && *txtpos<='9');
    ignore_blanks();	if(*txtpos!=NL){	printmsg(badinputmsg);	goto again;}
    if(isneg)  *var=-*var;
    goto run_next_statement;
  }
mem:  // memory free
  printnum(stack_limit-program_end);
  printmsg(memorymsg);
  goto run_next_statement;
awrite:
dwrite:{
  short int pinNo, val;
  expression_error=0;
  pinNo=checkParm();		// Get the pin number
  checkForComma();	if(stopFlag)	goto prompt; 
  expression_error=0; val=expression();
  pinMode(pinNo, OUTPUT);
  if(isDigital)	digitalWrite(pinNo, val);
  else          analogWrite( pinNo, val);
#if defined(ESP8266)											// ----ESP8266--------------
  char s[12]="dwrite "; itoa(pinNo, s+7, 10); strcat(s, ","); itoa(val, s+strlen(s), 10);
  wsServer.broadcastTXT(s, strlen(s));    // send data to all connected clients
#endif																		// -------------------------
  }
  goto run_next_statement;
#if defined(NUMLED)												// ----NUMLED---------------
numled:{
  char LED[]={0x3f, 0x06, 0x5b, 0x4f, 0x66, 0x6d, 0x7d, 0x27, 0x7f, 0x67};
  short int num=checkParm();
#if defined(__AVR_ATmega32U4__)						// ----ProMicro-------------
  pinMode(16,OUTPUT);digitalWrite(16,LED[num]&0x01);       // a
  pinMode(10,OUTPUT);digitalWrite(10,(LED[num]&0x02)>>1);  // b
  pinMode( 9,OUTPUT);digitalWrite( 9,(LED[num]&0x04)>>2);  // c
  pinMode( 8,OUTPUT);digitalWrite( 8,(LED[num]&0x08)>>3);  // d
  pinMode( 7,OUTPUT);digitalWrite( 7,(LED[num]&0x10)>>4);  // e
  pinMode(14,OUTPUT);digitalWrite(14,(LED[num]&0x20)>>5);  // f
  pinMode(15,OUTPUT);digitalWrite(15,(LED[num]&0x40)>>6);  // g
#elif defined(__SAMD21__)									// ----XIAO-----------------
  pinMode( 8,OUTPUT);digitalWrite( 8,LED[num]&0x01);       // a
  pinMode( 7,OUTPUT);digitalWrite( 7,(LED[num]&0x02)>>1);  // b
  pinMode( 6,OUTPUT);digitalWrite( 6,(LED[num]&0x04)>>2);  // c
  pinMode( 5,OUTPUT);digitalWrite( 5,(LED[num]&0x08)>>3);  // d
  pinMode( 4,OUTPUT);digitalWrite( 4,(LED[num]&0x10)>>4);  // e
  pinMode( 9,OUTPUT);digitalWrite( 9,(LED[num]&0x20)>>5);  // f
  pinMode(10,OUTPUT);digitalWrite(10,(LED[num]&0x40)>>6);  // g
#else																			// ----NANO-----------------
  DDRD|=0xfc; DDRB|=0x01;
  if(num>=0 && num<=9){
    PORTD=(PORTD&0x03)|(LED[num]<<2); PORTB=(PORTB&0xfe)|(LED[num]>>6);
  }else{ PORTD&=0x03; PORTB&=0xfe; }
#endif																		// -------------------------
}
  goto run_next_statement;
#endif																		// -------------------------
#if defined(PIXEL)												// ----NEOPIXEL-------------
servo:{
  short int pin, angle;
  expression_error=0; pin=checkParm();
  checkForComma(); if(stopFlag) goto prompt;
  expression_error=0; angle=expression();
  myservo.attach(pin); myservo.write(angle);
  servoMillis=millis();
  }
  goto run_next_statement;
pixel:{
  unsigned int ledNo, rval, gval, bval;
  expression_error=0;
  ledNo=checkParm();if(stopFlag)goto prompt;		// Get the LED number
  checkForComma();	if(stopFlag)goto prompt;
  rval=checkParm(); if(stopFlag)goto prompt;    // get RED/HUE value(0-255)
  if(check_statement_end()){		// *** pixel LED,HUE ***
  	unsigned int hue=rval;
		if(hue<85){				bval=0;gval=hue*3;		  rval=255-gval;}
		else if(hue<170){	rval=0;bval=(hue-85)*3; gval=255-bval;}
		else{							gval=0;rval=(hue-170)*3;bval=255-rval;}
  }else{
	  checkForComma();	if(stopFlag)goto prompt;
  	gval=checkParm(); if(stopFlag)goto prompt;  // get GREEN/BRIGHTNESS value(0-255)
  	if(check_statement_end()){	// *** pixel LED,HUE,BRIGHTNESS ***
  		unsigned int hue=rval, brightness=gval;
      if(hue<85){       bval=0;gval=hue*3;      rval=(255-gval)*brightness/255;  gval=gval*brightness/255;}
      else if(hue<170){ rval=0;bval=(hue-85)*3; gval=(255-bval)*brightness/255;  bval=bval*brightness/255;}
      else{             gval=0;rval=(hue-170)*3;bval=(255-rval)*brightness/255;  rval=rval*brightness/255;}
  	}else{											// *** pixel LED,R,G,B ***
  		checkForComma();	if(stopFlag)goto prompt;
  		bval=checkParm(); if(stopFlag)goto prompt;// get BLUE value(0-255)
		}
	}
	pixels.setPixelColor(ledNo, rval,gval,bval); pixels.show();
}
  goto run_next_statement;
#endif																		// ------------------------
#if defined(I2C)													// ----I2C-----------------
motor:{
#define M1 0x64
#define M2 0x60
  short int left, right, dir;
  expression_error=0; left=checkParm();
  checkForComma(); if(stopFlag) goto prompt;
  expression_error=0; right=expression();
  if(left==0)      dir=3;      // STOP
  else if(left>0){ dir=1; left=map( left, 1,255, 6,63);}// FWD
  else{            dir=2; left=map(-left, 1,255, 6,63);}// BWD
  Wire.beginTransmission(M1); Wire.write(0x00); Wire.write((left<<2)+dir); Wire.endTransmission();
  if(right==0)      dir=3;     // STOP
  else if(right>0){ dir=1; right=map( right, 1,255, 6,63);}// FWD
  else{             dir=2; right=map(-right, 1,255, 6,63);}// BWD
  Wire.beginTransmission(M2); Wire.write(0x00); Wire.write((right<<2)+dir); Wire.endTransmission();
  }
  goto run_next_statement;
#endif
cls:
#if defined(__AVR_ATmega32U4__)						// ----ProMicro------------
  if(SerialFlag==0)   // if Serial connected
#endif																		// ------------------------
    Serial.print("\033[2J\033[1;1H");
#if defined(I2C)													// ----I2C-----------------
  lcd.clear();
#endif																		// ------------------------
#if defined(VIDEO)												// ----VIDEO---------------
#if defined(__SAMD21__)										// ----XIAO-----------------
	display.fillScreen(BLACK);
	display.setCursor(0,0);
#else																			// ------------------------
  TV.clear_screen();
#endif																		// ------------------------
#endif																		// ------------------------
  goto run_next_statement;
#if defined(ESP8266)											// ----ESP8266-------------
wifi:{
  char ssid[20], password[20], domain[20]="esp8266", *p;
  ignore_blanks();
  char delim=*txtpos;
  if(delim!='"' && delim!='\'')  goto syntaxerror;
  txtpos++;  p=ssid;
  while(*txtpos!=delim){
    if(*txtpos==NL) goto syntaxerror;
    *p++=*txtpos++;
  }
  txtpos++;  *p='\0';
  checkForComma(); if(stopFlag) goto prompt;
  delim=*txtpos;
  if(delim!='"' && delim!='\'')  goto syntaxerror;
  txtpos++;  p=password;
  while(*txtpos!=delim){
    if(*txtpos==NL) goto syntaxerror;
    *p++=*txtpos++;
  }
  txtpos++;  *p='\0';
  ignore_blanks(); if(*txtpos==NL) goto default_domain;
  checkForComma(); if(stopFlag) goto prompt;
  delim=*txtpos;
  if(delim!='"' && delim!='\'')  goto syntaxerror;
  txtpos++;  p=domain;
  while(*txtpos!=delim){
    if(*txtpos==NL) goto syntaxerror;
    *p++=*txtpos++;
  }
  txtpos++;  *p='\0';
default_domain:
//WiFi.softAP((const char *)ssid, (const char *)password);
//Serial.print("AP IP address: "); Serial.println(WiFi.softAPIP());
  if(WiFi.status()!=WL_CONNECTED){
    WiFi.begin((const char *)ssid, (const char *)password);
    Serial.println(""); while(WiFi.status()!=WL_CONNECTED){ delay(500); Serial.print(".");}
    Serial.print("IP address: "); Serial.println(WiFi.localIP());
    if(mdns.begin(domain)){
      Serial.println("MDNS responder started");
      mdns.addService("http", "tcp", 80);
      mdns.addService("ws",   "tcp", 81);
    }else Serial.println("MDNS.begin failed");
    Serial.print("Connect to http://");Serial.print(domain);Serial.print(".local or http://"); Serial.println(WiFi.localIP());
//  Serial.print("Connect to http://esp8266.local or http://"); Serial.println(WiFi.softAPIP());
    if(timeClient.update()) setTime(timeClient.getEpochTime());  // NTP time sync
    webServer.on("/", handleRoot); webServer.onNotFound(handleNotFound);
    webServer.begin();
    wsServer.begin(); wsServer.onEvent(wsEvent);
  }else Serial.println("WiFi already connected.");
  }
  goto run_next_statement;
title:{
  char *p;
  ignore_blanks();
  char delim=*txtpos;
  if(delim!='"' && delim!='\'')  goto syntaxerror;
  txtpos++;  p=TITLE;
  while(*txtpos!=delim){
    if(*txtpos==NL) goto syntaxerror;
    *p++=*txtpos++;
  }
  txtpos++;  *p='\0';
  String str=String("title:")+TITLE;
  int strlen=str.length();
  char charstr[strlen+1]; str.toCharArray(charstr, strlen+1);
  wsServer.broadcastTXT(charstr, strlen);
  }
  goto run_next_statement;
button:{
  short int bnum;
  char *p;
  expression_error=0; bnum=checkParm();
  if(bnum<1 || bnum>9) goto syntaxerror;  // bnum: 1-9
  bnum--; // bnum: 0-8
  checkForComma(); if(stopFlag) goto prompt;
  ignore_blanks();
  char delim=*txtpos;
  if(delim!='"' && delim!='\'')  goto syntaxerror;
  txtpos++;  p=BUTTON[bnum][0];
  while(*txtpos!=delim){
    if(*txtpos==NL) goto syntaxerror;
    *p++=*txtpos++;
  }
  txtpos++;  *p='\0';
  checkForComma(); if(stopFlag) goto prompt;
  ignore_blanks();
  delim=*txtpos;
  if(delim!='"' && delim!='\'')  goto syntaxerror;
  txtpos++;  p=BUTTON[bnum][1];
  while(*txtpos!=delim){
    if(*txtpos==NL) goto syntaxerror;
    *p++=*txtpos++;
  }
  txtpos++;  *p='\0';
  }
  wsServer.broadcastTXT("reload",6);
  goto run_next_statement;
slider:{
  short int snum, sval;
  char *p;
  snum=checkParm();
  if(snum<1 || snum>2) goto syntaxerror;  // snum: 1-2
  checkForComma(); if(stopFlag) goto prompt;
  ignore_blanks();

  char delim=*txtpos;
  if(delim!='"' && delim!='\'')  goto syntaxerror;
  txtpos++;  p=SLIDER[0][snum];
  while(*txtpos!=delim){
   if(*txtpos==NL) goto syntaxerror;
    *p++=*txtpos++;
  }
  txtpos++;  *p='\0';
  checkForComma(); if(stopFlag) goto prompt;
  ignore_blanks();
  delim=*txtpos;
  if(delim!='"' && delim!='\'')  goto syntaxerror;
  txtpos++;  p=SLIDER[1][snum];
  while(*txtpos!=delim){
    if(*txtpos==NL) goto syntaxerror;
    *p++=*txtpos++;
  }
  txtpos++;  *p='\0';
  wsServer.broadcastTXT("reload",6);
  }
  goto run_next_statement;
bar:{
  short int bnum, bval;
  char *p, bname[80];
  bnum=checkParm();
  if(bnum<1 || bnum>3) goto syntaxerror;  // bnum: 1-3
  checkForComma(); if(stopFlag) goto prompt;
  ignore_blanks();
  char delim=*txtpos;
  if(delim!='"' && delim!='\'')  goto syntaxerror;
  txtpos++;  p=bname;
  while(*txtpos!=delim){
   if(*txtpos==NL) goto syntaxerror;
    *p++=*txtpos++;
  }
  txtpos++;  *p='\0';
  checkForComma(); if(stopFlag) goto prompt;
  bval=checkParm();if(stopFlag) goto prompt;
  String str=String("bar:")+bnum+","+bname+","+bval;
  int strlen=str.length();
  char charstr[strlen+1]; str.toCharArray(charstr, strlen+1);
  wsServer.broadcastTXT(charstr, strlen);
  }
  goto run_next_statement;
#endif																		// ------------------------
// --------------------------------------------------------------------------
forloop:{
    unsigned char var;
    short int initial, step, terminal;
    if(*txtpos<'A' || *txtpos>'Z')  goto syntaxerror;
    var=*txtpos;
    txtpos++;
    scantable(relop_tab);	if(table_index != RELOP_EQ)  goto syntaxerror;
    expression_error=0;
    initial=expression(); if(expression_error) goto invalidexpr;
    scantable(to_tab);    if(table_index != 0) goto syntaxerror;
    terminal=expression();if(expression_error) goto invalidexpr;
    scantable(step_tab);
    if(table_index==0){
      step=expression();	if(expression_error) goto invalidexpr;
    }else  step=1;
    if(!check_statement_end())  goto syntaxerror;
    if(!expression_error && *txtpos==NL){
      struct stack_for_frame *f;
      if(spt-sizeof(struct stack_for_frame)<stack_limit)  goto nomem; // *** '+' -> '-' ***
      spt-=sizeof(struct stack_for_frame);
      f=(struct stack_for_frame *)spt;
      ((short int *)variables_table)[var-'A'] = initial;
      f->frame_type = STACK_FOR_FLAG;
      f->for_var  = var;
      f->terminal = terminal;
      f->step     = step;
      f->txtpos   = txtpos;
      f->current_line = current_line;
      goto run_next_statement;
    }
  }
  goto syntaxerror;
gosub:
  expression_error=0;
  linenum=expression();	if(expression_error)  goto invalidexpr;
  if(!expression_error && *txtpos==NL){
    struct stack_gosub_frame *f;
    if(spt+sizeof(struct stack_gosub_frame)<stack_limit)  goto nomem;
    spt -= sizeof(struct stack_gosub_frame);
    f = (struct stack_gosub_frame *)spt;
    f->frame_type = STACK_GOSUB_FLAG;
    f->txtpos = txtpos;
    f->current_line=current_line;
    current_line=findline();
    goto execline;
  }
  goto syntaxerror;
next:  // Find the variable name
  ignore_blanks();	if(*txtpos<'A' || *txtpos>'Z')  goto syntaxerror;
  txtpos++;	if(!check_statement_end())  goto syntaxerror;
gosub_return:  // Now walk up the stack frames and find the frame we want, if present
  for(tempsp=spt; tempsp<memory+sizeof(memory)-1; ){
    switch(tempsp[0]){
    case STACK_GOSUB_FLAG:
      if(table_index==KW_RETURN){
        struct stack_gosub_frame *f=(struct stack_gosub_frame *)tempsp;
        current_line = f->current_line;
        txtpos			 = f->txtpos;
        spt += sizeof(struct stack_gosub_frame);
        goto run_next_statement;
      }
      // This is not the loop you are looking for... so Walk back up the stack
      tempsp += sizeof(struct stack_gosub_frame);
      break;
    case STACK_FOR_FLAG:
      // Flag, Var, Final, Step
      if(table_index==KW_NEXT){
        struct stack_for_frame *f=(struct stack_for_frame *)tempsp;
        if(txtpos[-1] == f->for_var){        // Is the the variable we are looking for?
          short int *varaddr = ((short int *)variables_table) + txtpos[-1] - 'A'; 
          *varaddr = *varaddr + f->step;
          // Use a different test depending on the sign of the step increment
          if((f->step>0 && *varaddr <= f->terminal) || (f->step < 0 && *varaddr >= f->terminal)){
            // We have to loop so don't pop the stack
            txtpos = f->txtpos;
            current_line = f->current_line;
            goto run_next_statement;
          }
          // We've run to the end of the loop. drop out of the loop, popping the stack
          spt=tempsp+sizeof(struct stack_for_frame);
          goto run_next_statement;
        }
      }
      // This is not the loop you are looking for... so Walk back up the stack
      tempsp += sizeof(struct stack_for_frame);
      break;
    default:	goto stackstuffed;
    }
  }
  goto syntaxerror;  // Didn't find the variable we've been looking for
assignment:{
    short int value, *var, a;
//    if(*txtpos<'A' || *txtpos>'Z')  goto syntaxerror;
//    var=(short int *)variables_table + *txtpos-'A';
// ******************************************
    if(*txtpos>='A' && *txtpos<='Z') var=(short int *)variables_table + *txtpos-'A';
    else if(*txtpos=='@'){						// Array
      txtpos++;
      if(*txtpos!='(')  goto syntaxerror;
      txtpos++;
      if(*txtpos!=')'){
        a=expression();
        ignore_blanks; if(*txtpos!=')') goto syntaxerror;
      }else a=0;
#if defined(ESP8266)||defined(__SAMD21__)	// ----ESP8266/XIAO---------
			var=atbuf+a;
#else																			// ----NANO/ProMicro--------
      var=(short int *)program_end+a;
#endif																		// -------------------------
    }else goto syntaxerror;
// ******************************************
    txtpos++;
    ignore_blanks();	if(*txtpos!='=')  goto syntaxerror;
    txtpos++; ignore_blanks(); 
    while(1){
      expression_error=0;
      value=expression();	if(expression_error)  goto invalidexpr;
      *var=value;
      ignore_blanks();
      if(*txtpos==','){ txtpos++; var++;  }
      else if(check_statement_end()) break;
      else goto syntaxerror;
    }
  }
  goto run_next_statement;
poke:{
    short int value;
    unsigned char *address;
    // Work out where to put it
    expression_error=0;
    value=expression();	if(expression_error)  goto invalidexpr;
#if defined(ESP8266)||defined(__SAMD21__)	// ----ESP8266/XIAO---------
		address=(unsigned char *)atbuf+value;
#else																			// ----NANO/ProMicro--------
    address=(unsigned char *)value;
#endif																		// -------------------------
    ignore_blanks();	if(*txtpos!=',')  goto syntaxerror;
    txtpos++; ignore_blanks();
    if(*txtpos=='"'){		// check for a quote
      for(txtpos++; *txtpos!='"'; txtpos++){
#if defined(ESP8266)||defined(__SAMD21__)	// ----ESP8266/XIAO---------
				*address=*txtpos;
#else																			// ----NANO/ProMicro--------
        memory[(int)address]=*txtpos;
#endif																		// -------------------------
        address++;
      }
#if defined(ESP8266)||defined(__SAMD21__)	// ----ESP8266/XIAO---------
			*address=0x0D;	// put newline at end of string
#else																			// ----NANO/ProMicro--------
      memory[(int)address]=0x0D;	// put newline at end of string
#endif																		// -------------------------
      txtpos++; goto run_next_statement;
    }
    expression_error=0;				// Now get the value to assign
    value=expression();	if(expression_error)  goto invalidexpr;
    memory[(int)address]=value;
    if(!check_statement_end())  goto syntaxerror;    // Check that we are at the end of the statement
  }
  goto run_next_statement;
setcursor:{
    short int x, y;
    x=checkParm();		if(stopFlag)goto prompt;
		checkForComma();	if(stopFlag)goto prompt;
    y=checkParm();		if(stopFlag)goto prompt;
#if defined(__AVR_ATmega32U4__)						// ----ProMicro-------------
    if(SerialFlag==0)   // if Serial connected
#endif																		// -------------------------
      Serial.print(String("\033[")+(y+1)+";"+(x+1)+"H");
#if defined(I2C)													// ----I2C------------------
    lcd.setCursor(x,y);
#endif																		// -------------------------
#if defined(VIDEO)												// ----VIDEO----------------
#if defined(__SAMD21__)										// ----XIAO-----------------
    if(x>=SCREEN_W/6) x=SCREEN_W/6-1;	if(x<0) x=0;
    if(y>=SCREEN_H/8) y=SCREEN_H/8-1;	if(y<0) y=0;
		display.setCursor(x*6,y*8);						// 6x8 font
#else																			// -------------------------
    if(x>=SCREEN_W/4) x=SCREEN_W/4-1;	if(x<0) x=0;
    if(y>=SCREEN_H/6) y=SCREEN_H/6-1;	if(y<0) y=0;
    TV.set_cursor(x*4,y*6);								// 4x6 font
#endif																		// -------------------------
#endif																		// -------------------------
    if(!check_statement_end())  goto syntaxerror;    // Check that we are at the end of the statement
  }
  goto run_next_statement;

mTone:{
    unsigned int pin, freq, dur;
    pin=checkParm(); if(stopFlag)goto prompt;
    if(check_statement_end()){
      noTone(pin);
#if defined(__AVR_ATmega32U4__)						// ----ProMicro-------------
      tonePin=255;
#endif																		// -------------------------
    }else{
      checkForComma(); if(stopFlag)goto prompt;
      freq=checkParm();if(stopFlag)goto prompt;  checkForComma();if(stopFlag)goto prompt;
      dur=checkParm(); if(stopFlag)goto prompt;
#if defined(__AVR_ATmega32U4__)						// ----ProMicro-------------
      if(pin!=tonePin && tonePin!=255)  noTone(tonePin);
      tonePin=pin;
#endif																		// -------------------------
      if(freq>0)	tone(pin, freq, dur);							// play only if freq is positive
      if(!check_statement_end())  goto syntaxerror; // Check that we are at the end of the statement
    }
  }
  goto run_next_statement;
#if defined(VIDEO)												// ----VIDEO----------------
shiftscreen:{						// shift entire screen 
    short int dist, dir;
		int16_t x, y;
    dist=checkParm();if(stopFlag)goto prompt;  checkForComma();if(stopFlag)goto prompt;
    dir=checkParm(); if(stopFlag)goto prompt;
#if defined(__SAMD21__)										// ----XIAO-----------------
		display.shiftPixel(dist,dir);
#else																			// -------------------------
    TV.shift(dist,dir);
#endif																		// -------------------------
    if(!check_statement_end())  goto syntaxerror;    // Check that we are at the end of the statement
  }
  goto run_next_statement;
plot:{												// replaced set and reset
    short int x, y, c;
    x=checkParm();if(stopFlag)goto prompt;  checkForComma();if(stopFlag)goto prompt;
    y=checkParm();if(stopFlag)goto prompt;  checkForComma();if(stopFlag)goto prompt;
    c=checkParm();if(stopFlag)goto prompt;
    if(x>=SCREEN_W) x=SCREEN_W-1;	if(x<0) x=0;
    if(y>=SCREEN_H) y=SCREEN_H-1;	if(y<0) y=0;
#if defined(__SAMD21__)										// ----XIAO-----------------
		if(c==2)	display.drawPixel(x,y,(display.getPixel(x,y)?0:255));
		else			display.drawPixel(x,y,(c?1:0)*255);
#else																			// -------------------------
    TV.set_pixel(x,y,c);
#endif																		// -------------------------
    if(!check_statement_end())	goto syntaxerror;   // Check that we are at the end of the statement
  }
  goto run_next_statement;
bmp:{												// bitmap image
  short int x0, x, y, c;
  x0=x=checkParm();if(stopFlag)goto prompt;  checkForComma();if(stopFlag)goto prompt;
  y=checkParm();	 if(stopFlag)goto prompt;  checkForComma();if(stopFlag)goto prompt;
  while(1){
    x=x0;
    if(x>=SCREEN_W) x=SCREEN_W-1;	if(x<0) x=0;
    if(y>=SCREEN_H) y=SCREEN_H-1;	if(y<0) y=0;
    ignore_blanks();
    unsigned char delim=*txtpos;
    if(delim!='"' && delim!='\'')  goto syntaxerror;
    txtpos++;
    for(int i=0;txtpos[i]!=delim;i++) if(txtpos[i]==NL) goto syntaxerror;
    for(;*txtpos!=delim; txtpos++){
      unsigned char px=*txtpos;
      if(px>=0x41&&px<=0x46 || px>=0x61&&px<=0x66)	px+=9;	// A-F, a-f
#if defined(__SAMD21__)										// ----XIAO-----------------
			display.drawPixel(x++,y,((px>>3)&0x01)*WHITE);
			display.drawPixel(x++,y,((px>>2)&0x01)*WHITE);
			display.drawPixel(x++,y,((px>>1)&0x01)*WHITE);
			display.drawPixel(x++,y,(px&0x01)*WHITE);
#else																			// -------------------------
      TV.set_pixel(x++,y,(px>>3)&0x01);
      TV.set_pixel(x++,y,(px>>2)&0x01);
      TV.set_pixel(x++,y,(px>>1)&0x01);
      TV.set_pixel(x++,y,px&0x01);
#endif																		// -------------------------
    }
    txtpos++; ignore_blanks();
    if(*txtpos==','){	txtpos++;	y++;	}
    else if(check_statement_end()) break;
    else goto syntaxerror;
  }
  }
  goto run_next_statement;
box:{
    short int t, x, y, x1, y1, color;
    x=checkParm(); if(stopFlag)goto prompt;  checkForComma();if(stopFlag)goto prompt;
    y=checkParm(); if(stopFlag)goto prompt;  checkForComma();if(stopFlag)goto prompt;
    x1=checkParm();if(stopFlag)goto prompt;  checkForComma();if(stopFlag)goto prompt;
    y1=checkParm();if(stopFlag)goto prompt;  checkForComma();if(stopFlag)goto prompt;
    color=checkParm();if(stopFlag)	goto prompt;    // Now get the value to assign
    if(x>=SCREEN_W)  x=SCREEN_W-1;	if(x<0)  x=0;
    if(y>=SCREEN_H)  y=SCREEN_H-1;	if(y<0)  y=0;
    if(x1>=SCREEN_W) x1=SCREEN_W-1;	if(x1<0) x1=0;
    if(y1>=SCREEN_H) y1=SCREEN_H-1;	if(y1<0) y1=0;
    if(x>x1){t=x;x=x1;x1=t;}
    if(y>y1){t=y;y=y1;y1=t;}
    x1-=x;	y1-=y;
    switch (color){
#if defined(__SAMD21__)										// ----XIAO-----------------
		case 0: display.drawRect(x,y,x1,y1,BLACK);	break;	// draw box border black
    case 1: display.drawRect(x,y,x1,y1,WHITE);  break;	// draw box border white
    case 10:display.fillRect(x,y,x1,y1,BLACK);	break;	// draw black box
    case 11:display.fillRect(x,y,x1,y1,WHITE);	break;	// draw white box
    default:																		// draw black box with white border
			display.fillRect(x,y,x1,y1,BLACK);	display.drawRect(x,y,x1,y1,WHITE);
#else																			// -------------------------
    case 0: TV.draw_rect(x,y,x1,y1,BLACK,-1);		  break;	// draw box border black
    case 1: TV.draw_rect(x,y,x1,y1,WHITE,-1);		  break;	// draw box border white
    case 2: TV.draw_rect(x,y,x1,y1,INVERT,-1);		break;	// invert the box border
    case 10:TV.draw_rect(x,y,x1,y1,BLACK,BLACK);	break;	// draw black box
    case 11:TV.draw_rect(x,y,x1,y1,WHITE,WHITE);	break;	// draw white box
    case 12:TV.draw_rect(x,y,x1,y1,INVERT,INVERT);	break;	// invert the box color
    default:TV.draw_rect(x,y,x1,y1,WHITE,BLACK);			// draw black box with white border
#endif																		// -------------------------
    }  
    if(!check_statement_end())  goto syntaxerror;    // Check that we are at the end of the statement
  }
  goto run_next_statement;
line:{
    short int x, y, x1, y1, color;
    x=checkParm();		if(stopFlag)goto prompt;  checkForComma();if(stopFlag)goto prompt;
    y=checkParm();		if(stopFlag)goto prompt;  checkForComma();if(stopFlag)goto prompt;
    x1=checkParm();		if(stopFlag)goto prompt;  checkForComma();if(stopFlag)goto prompt;
    y1=checkParm();		if(stopFlag)goto prompt;  checkForComma();if(stopFlag)goto prompt;
    color=checkParm();if(stopFlag)goto prompt;    // Now get the value to assign
    if(x>=SCREEN_W)  x=SCREEN_W-1;	if(x<0)  x=0;
    if(y>=SCREEN_H)  y=SCREEN_H-1;	if(y<0)  y=0;
    if(x1>=SCREEN_W) x1=SCREEN_W-1;	if(x1<0) x1=0;
    if(y1>=SCREEN_H) y1=SCREEN_H-1;	if(y1<0) y1=0;
    switch (color){
#if defined(__SAMD21__)										// ----XIAO-----------------
    case 0:	display.drawLine(x,y,x1,y1,BLACK);	break;	// erase box
    case 1:	display.drawLine(x,y,x1,y1,WHITE);	break;	// draw box
    default:display.drawLine(x,y,x1,y1,WHITE);
#else																			// -------------------------
    case 0:	TV.draw_line(x,y,x1,y1,BLACK);	break;			// erase box
    case 1:	TV.draw_line(x,y,x1,y1,WHITE);	break;			// draw box
    case 2:	TV.draw_line(x,y,x1,y1,INVERT);	break;			// invert the box
    default:TV.draw_line(x,y,x1,y1,WHITE);
#endif																		// -------------------------
    }
    // Check that we are at the end of the statement
    if(!check_statement_end())	goto syntaxerror;
  }
  goto run_next_statement;
circle:{
    short int x, y, radius, color;
    x=checkParm();		if(stopFlag)goto prompt;  checkForComma();	if(stopFlag)goto prompt;
    y=checkParm();		if(stopFlag)goto prompt;  checkForComma();	if(stopFlag)goto prompt;
    radius =checkParm();if(stopFlag)goto prompt;  checkForComma();	if(stopFlag)goto prompt;
    // Now get the value to assign
    color=checkParm();	if(stopFlag)  goto prompt;
    if(x>=SCREEN_W) x=SCREEN_W-1;	if(x<0) x=0;
    if(y>=SCREEN_H) y=SCREEN_H-1;	if(y<0) y=0;
    switch (color){
#if defined(__SAMD21__)										// ----XIAO-----------------
    case 0:	display.drawCircle(x,y,radius,BLACK);	break;	// draw circle border black
    case 1:	display.drawCircle(x,y,radius,WHITE);	break;	// draw circle border white
    case 10:display.fillCircle(x,y,radius,BLACK);	break;	// draw black circle
    case 11:display.fillCircle(x,y,radius,WHITE);	break;	// draw white circle
    default:display.drawCircle(x,y,radius,WHITE);			// draw black circle with white border
#else																			// -------------------------
    case 0:	TV.draw_circle(x,y,radius,BLACK,-1);	break;	// draw circle border black
    case 1:	TV.draw_circle(x,y,radius,WHITE,-1);	break;	// draw circle border white
    case 2:	TV.draw_circle(x,y,radius,INVERT,-1);	break;	// invert the circle border
    case 10:TV.draw_circle(x,y,radius,BLACK,BLACK);	break;	// draw black circle
    case 11:TV.draw_circle(x,y,radius,WHITE,WHITE);	break;	// draw white circle
    case 12:TV.draw_circle(x,y,radius,INVERT,INVERT);break;	// invert the circle color
    default:TV.draw_circle(x,y,radius,WHITE,BLACK);			// draw black circle with white border
#endif																		// -------------------------
    }  
    // Check that we are at the end of the statement
    if(!check_statement_end())  goto syntaxerror;
  }
  goto run_next_statement;
#endif																		// -------------------------
list:
  linenum=testnum(); // Retuns 0 if no line found.
  if(*txtpos=='.'){
    list_line=findline();
    printline();
    goto warmstart;
  }
  if(*txtpos == '-'){
    int lincount=0, numlines=5;
    for(list_line=findline(); lincount!=numlines; lincount ++){
      printline();
      if(list_line==program_end)  goto warmstart;
    }
    goto warmstart;
  }
  if(txtpos[0]!=NL)  goto syntaxerror;		// Should be EOL
  for(list_line=findline(); list_line!=program_end; )	printline();
  goto warmstart;

eLoad:{	// load from EEPROM to RAM
#if defined(ESP8266)||defined(__SAMD21__)	// ----ESP8266/XIAO---------
  unsigned short size = EEPROM.read(EESIZE-2) + (EEPROM.read(EESIZE-1)<<8);
#else																			// ----NANO/ProMicro--------
  int size=(EEPROM.read(EESIZE-2))+(EEPROM.read(EESIZE-1)<<8);
#endif																		// -------------------------
  if(size<=EESIZE-2){
    program_end=program_start+size;
    for(int i=0; i<size; i++)	memory[i+27*VAR_SIZE]=EEPROM.read(i);
  }
  }
  goto warmstart;
eSave:{  // save memory to the EEPROM-EESIZE bytes, current usable RAM
  int size=int(program_end)-int(program_start);
  for(int i=0; i<size; i++)	EEPROM.write(i, memory[i+27*VAR_SIZE]);
  EEPROM.write(EESIZE-2, size&0xff); EEPROM.write(EESIZE-1, size>>8);
#if defined(ESP8266)||defined(__SAMD21__)	// ----ESP8266/XIAO---------
  EEPROM.commit();
#endif																		// -------------------------
  }
  goto warmstart;
print:  // If we have an empty list then just put out a NL
  if(*txtpos==':'){	line_terminator();	txtpos++;	goto run_next_statement;	}
  if(*txtpos==NL)  goto execnextline;
  while(1){
    ignore_blanks();
    if(print_quoted_string()) ;
    else if(*txtpos=='"' || *txtpos=='\'')  goto syntaxerror;
    else{
      expression_error=0;
      short int e=expression();
      if(expression_error && expression_error!=15)   goto invalidexpr;
      if(expression_error!=15)	printnum(e);
    }
    // At this point we have three options, a comma or a new line
    if(*txtpos==',')	txtpos++;	// Skip the comma and move onto the next
    else if(txtpos[0]==';' && (txtpos[1]==NL || txtpos[1]==':')){
      txtpos++; // This has to be the end of the print - no newline
      break;
    }else if(check_statement_end()){	line_terminator();	break;}	// The end of the print statement
    else  goto syntaxerror;
  }
  goto run_next_statement;
#if defined(PIXEL)												// ----NEOPIXEL-------------
f38k:{
    unsigned int led, cycle;
    led=checkParm();  if(stopFlag)goto prompt;  checkForComma();if(stopFlag)goto prompt;
    cycle=checkParm();if(stopFlag)goto prompt;
    pinMode(led, OUTPUT); _f38k(led, cycle);
  }
  goto run_next_statement;
rcbyte:{                      // 複数バイトの赤外線信号
    unsigned int led, data;  
    led=checkParm(); if(stopFlag)goto prompt;  checkForComma();if(stopFlag)goto prompt;
    while(1){
      data=checkParm();if(stopFlag)goto prompt;
      _rc(led,data&0x01); _rc(led,data&0x02); _rc(led,data&0x04); _rc(led,data&0x08); // ビット0, 1, 2, 3
      _rc(led,data&0x10); _rc(led,data&0x20); _rc(led,data&0x40); _rc(led,data&0x80); // ビット4, 5, 6, 7
      checkForComma2();if(stopFlag)break;
    }
    _rc(led,0);
  }
  goto run_next_statement;
scbyte:{                      // 複数バイトの赤外線信号(SONY)
    unsigned int led, data;  
    led=checkParm(); if(stopFlag)goto prompt;  checkForComma();if(stopFlag)goto prompt;
    data=checkParm();if(stopFlag)goto prompt;
    for(uint8_t i=0;i<3;i++){
      pinMode(led, OUTPUT); _f38k(led, 2500/26);
      _sc(led,data&0x01); _sc(led,data&0x02); _sc(led,data&0x04); _sc(led,data&0x08); // ビット0, 1, 2, 3
      _sc(led,data&0x10); _sc(led,data&0x20); _sc(led,data&0x40); _sc(led,data&0x80); // ビット4, 5, 6, 7
      _sc(led,0);_sc(led,0);_sc(led,0);_sc(led,0); delay(27);
    }
  }
  goto run_next_statement;
#endif																		// ------------------------
#if defined(I2C)													// ----I2C-----------------
talk:  // If we have an empty list then just put out a NL
  if(*txtpos==':'){ txtpos++; goto run_next_statement; }
  if(*txtpos==NL) goto execnextline;
  while(1){
    ignore_blanks();
    if(talk_quoted_string());
    else if(*txtpos=='"') goto syntaxerror;
    else{
      expression_error=0;
      short int e=expression();
      if(expression_error && expression_error!=15) goto invalidexpr;
      if(expression_error!=15) talknum(e);
    }
    // At this point we have three options, a comma or a new line
    if(*txtpos==',') txtpos++;  // Skip the comma and move onto the next
    else if(check_statement_end()) break;  // The end of the talk statement
    else  goto syntaxerror;
  }
  goto run_next_statement;
#endif																		// -------------------------

#if defined(ESP8266)											// ----ESP8266--------------
#elif defined(__SAMD21__)									// ----XIAO-----------------
sleep:{																		// *** intPin is 1 ***
  nrgSave.begin(WAKE_EXT_INTERRUPT, 1, pin_isr);  // standby setup
  nrgSave.standby();
  }
  goto run_next_statement;
#elif defined(__AVR_ATmega32U4__)					// ----ProMicro-------------
sleep:{																		// *** intPin is 1 ***
    pinMode(1, INPUT_PULLUP);
    sleep_enable();
    attachInterrupt(digitalPinToInterrupt(intPin),pin_isr,LOW);
    set_sleep_mode(SLEEP_MODE_PWR_DOWN);
    cli();
    sei();
    sleep_cpu();
    // wake up !!
    sleep_disable();
  }
  goto run_next_statement;
#else																			// ----NANO-----------------
sleep:{																		// *** intPin is 2 ***
    pinMode(2, INPUT_PULLUP);
    sleep_enable();
    attachInterrupt(digitalPinToInterrupt(intPin),pin_isr,LOW);
    set_sleep_mode(SLEEP_MODE_PWR_DOWN);
    cli();
    sleep_bod_disable();
    sei();
    sleep_cpu();
    // wake up !!
    sleep_disable();
  }
  goto run_next_statement;
#endif
}
/***************************************************************************/
#if defined(PIXEL)												// ----NEOPIXEL-------------
#if defined(__AVR_ATmega32U4__)						// ----ProMicro-------------
#define _CNT10 8
#elif defined(ESP8266)										// ----ESP8266--------------
#define _CNT10 12
#elif defined(__SAMD21__)									// ----XIAO-----------------
#define _CNT10 12
#else																			// ----NANO-----------------
#define _CNT10 10
#endif																		// -------------------------
void _f38k(int led, int n){                         // 26μs × n周期
  for(int j=0;j<n;j++){
    digitalWrite(led, HIGH);	// 13μs点灯
#if F_CPU==8000000L   										// 8MHz
    delayMicroseconds(6);
#else																			// -------------------------
    delayMicroseconds(_CNT10);
#endif																		// -------------------------
    digitalWrite(led, LOW); 	// 13μs消灯
#if F_CPU==8000000L   										// 8MHz
    delayMicroseconds(5);
#else 											 							// -------------------------
    delayMicroseconds(_CNT10-1);
#endif																		// -------------------------
  }
}
void _rc(int led, uint8_t b){
  if(b==0){_f38k(led,300/26); delayMicroseconds(700);} // 「0」の赤外線信号
  else{    _f38k(led,300/26); delayMicroseconds(1800);}// 「1」の赤外線信号
}
void _sc(int led, uint8_t b){
  if(b==0){delayMicroseconds(600);_f38k(led,600/26); } // 「0」の赤外線信号(SONY)
  else{    delayMicroseconds(600);_f38k(led,1200/26); }// 「1」の赤外線信号(SONY)
}
#endif
/***************************************************************************/
void pin_isr(){
#if defined(ESP8266)											// ----ESP8266--------------
#elif defined(__SAMD21__)									// ----XIAO-----------------
#else																			// ----NANO/ProMicro--------
  sleep_disable();
  detachInterrupt(digitalPinToInterrupt(intPin));
#endif																		// -------------------------
}
/***************************************************************************/
#if defined(ESP8266)											// ----ESP8266--------------
void wsEvent(uint8_t num, WStype_t type, uint8_t *payload, size_t length){
  Serial.printf("webSocketEvent(%d, %d, ...)\r\n", num, type);
  switch(type){
    case WStype_DISCONNECTED: Serial.printf("[%u] Disconnected!\r\n", num); break;
    case WStype_CONNECTED:{
        Serial.print("["); Serial.print(num); Serial.print("] Connected from "); Serial.print(wsServer.remoteIP(num));
        Serial.print(" url: "); Serial.println(*payload);
      }
      break;
    case WStype_TEXT:
      Serial.printf("[%u] get Text: %s\r\n", num, payload);
      if(strncmp("read ", (const char *)payload+1, 5)!=0) wsServer.broadcastTXT(payload, length);      // send data to all connected clients
      if(strcmp("list", (const char *)payload)==0) sendlist();
      else if(strcmp("ESC", (const char *)payload)==0){
        ESCflag=true;
      }else if(strncmp("dwrite ", (const char *)payload, 7)==0){
        char *p=strchr((const char *)(payload+7), ',');
        if(p!=0){
          *p='\0';
          int pin=atoi((const char *)(payload+7));
          *p++=',';
          pinMode(pin, OUTPUT); digitalWrite(pin, atoi(p));
        }
      }else if(strncmp("awrite ", (const char *)payload, 7)==0){
        char *p=strchr((const char *)(payload+7), ',');
        if(p!=0){
          *p='\0';
          int pin=atoi((const char *)(payload+7));
          *p++=',';
          pinMode(pin, OUTPUT); analogWrite(pin, atoi(p));
        }
      }else if(strncmp("dread ", (const char *)payload, 6)==0){
        int pin=atoi((const char *)(payload+6));
        pinMode(pin, INPUT_PULLUP);
        char str[10]="D"; itoa(pin, str+1, 10); strcat(str, ":"); itoa(digitalRead(pin), str+strlen(str), 10);
        wsServer.broadcastTXT(str, strlen(str));      // send data to all connected clients
      }else if(strncmp("aread ", (const char *)payload, 6)==0){
        int pin=atoi((const char *)(payload+6));
        pinMode(pin, INPUT_PULLUP);
        char str[10]="A"; itoa(pin, str+1, 10); strcat(str, ":"); itoa(analogRead(pin), str+strlen(str), 10);
        wsServer.broadcastTXT(str, strlen(str));      // send data to all connected clients      
      }else{
        strcat(wsbuf, (const char *)payload); strcat(wsbuf, "\n");
        Serial.println(wsbuf);
      }
      break;
    case WStype_BIN:
      Serial.printf("[%u] get binary length: %u\r\n", num, length);
      hexdump(payload, length);
      wsServer.sendBIN(num, payload, length);      // echo data back to browser
      break;
    default: Serial.printf("Invalid WStype [%d]\r\n", type); break;
  }
}
void handleRoot(){
  String html=INDEX_HTML;
  html.replace("%TITLE%",TITLE);
  String s="<table>\r\n<tr>";
  for(int i=0; i<9; i++){
    if(BUTTON[i][0][0]=='\0') s+="<td></td>";
    else{
      s+="<th><button onclick=\'ws.send(\""; s+=BUTTON[i][1]; s+="\")\'>";
      s+=BUTTON[i][0]; s+="</button></th>";
    }
    if(i==2||i==5) s+="</tr>\n<tr>";
  }
  s+="</tr>\n</table>\n";
  html.replace("%BUTTON%",s);
  s="<table>\n";
  for(int i=0;i<3;i++){
    if(SLIDER[0][i][0]!='\0'){
      s+="<tr><td>"; s+=SLIDER[0][i];  s+="</td><td>";
      s+="<input type=range value=0 min=0 max=255 step=10 onchange='ws.send(\""; s+=SLIDER[1][i]; s+="\")\'>";
      s+="</td></tr>\n";
      s.replace("%%","\"+this.value+\"");
    }
  }
  s+="</table>\n";
  html.replace("%SLIDER%",s);
  webServer.send(200, "text/html", html);
}
void handleNotFound(){
  String message="File Not Found\n\n";
  message+="URI: "+webServer.uri();
  message+="\nMethod: "+(webServer.method()==HTTP_GET)?"GET":"POST";
  message+="\nArguments: ";  message+=webServer.args()+"\n";
  for(uint8_t i=0; i<webServer.args(); i++) message+=" "+webServer.argName(i)+": "+webServer.arg(i)+"\n";
  webServer.send(404, "text/plain", message);
}
#endif																		// -------------------------
/***************************************************************************/
void checkForComma2(void){
  ignore_blanks();
  if(*txtpos==','){ txtpos++; ignore_blanks(); stopFlag=false; }
  else stopFlag=true;
}
/***************************************************************************/
static int checkParm(void){
  expression_error=0;
  int value=expression();
  if(expression_error){	printmsg(invalidexprmsg);	stopFlag=true;	return 0;}
  else{	stopFlag=false;	return value;	}
}
/***************************************************************************/
static int checkForComma(void){
  ignore_blanks();
  if(*txtpos!=','){
    printmsg(syntaxmsg);
    if(current_line!=(void *)0){
      unsigned char tmp=*txtpos;
      if(*txtpos!=NL)  *txtpos='^';
      list_line=current_line;
      printline();
      *txtpos=tmp;
    }
    line_terminator();
    stopFlag=true;
  }else{ 
    txtpos++;
    ignore_blanks();
    stopFlag=false;
  }
}
/***************************************************************************/
static void line_terminator(void){	outchar(NL);	outchar(CR);	}
/***********************************************************/
static unsigned char breakcheck(void){
#ifndef VIDEO
  if(myservo.attached() && millis()>(servoMillis+TSERVO))  myservo.detach();
#endif
#if defined(__AVR_ATmega32U4__)					// ----ProMicro---------------
    if(SerialFlag>0 && ++SerialFlag==100){
      if(Serial) SerialFlag=0;  // Serial connected
      else       SerialFlag=1;
    }
  if(SerialFlag==0 && Serial.available())    return Serial.read()==ESC;
#elif defined(ESP8266)									// ----ESP8266----------------
  wsServer.loop();
  webServer.handleClient();
  if(ESCflag){ ESCflag=false; return 1; }
  else if(Serial.available()) return Serial.read()==ESC;
#else																		// ----NANO/XIAO--------------
  if(Serial.available())    return Serial.read()==ESC;
#endif																	// ---------------------------
#ifdef KEYBOARD
  else if(keyboard.available())	return keyboard.read()==ESC;
#endif
  else  return 0;
}
/***********************************************************/
static int inchar(){
  while(1){
#ifndef VIDEO
  if(myservo.attached() && millis()>(servoMillis+TSERVO))  myservo.detach();
#endif
#ifdef __AVR_ATmega32U4__
    if(SerialFlag>0 && ++SerialFlag==100){
      if(Serial) SerialFlag=0;  // Serial connected
      else       SerialFlag=1;
    }
    if(SerialFlag==0 && Serial.available())      return Serial.read();
#elif defined(ESP8266)
    wsServer.loop();
    webServer.handleClient();
    if(*pws!=0) return *pws++;
    else if(Serial.available()) return Serial.read();
#else
    if(Serial.available())			return Serial.read();
#endif
#ifdef KEYBOARD
	  else if(keyboard.available())	return keyboard.read();	// read the next key
#endif
  }
}
/***********************************************************/
static void outchar(unsigned char c){
#if defined(__AVR_ATmega32U4__)						// ----ProMicro-------------
  if(SerialFlag==0)   // if Serial connected
#endif																		// -------------------------
		Serial.write(c);
#if defined(I2C)													// ----I2C------------------
  if(c!=NL && c!=CR)  lcd.write(c);
  else lcd.setCursor(0,1);
#endif																		// -------------------------
#if defined(VIDEO)												// ----VIDEO----------------
#if defined(__SAMD21__)										// ----XIAO-----------------
	display.write(c);
#else																			// -------------------------
  TV.print(c);
#endif																		// -------------------------
#endif																		// -------------------------
}
/***********************************************************/
void setup(){
#if defined(ESP8266)											// ----ESP8266--------------
  Serial.begin(115200);// opens serial port, sets data rate to 115200 bps
  EEPROM.begin(1024);
#elif defined(__SAMD21__)									// ----XIAO-----------------
  Serial.begin(115200);// opens serial port, sets data rate to 115200 bps
#else																			// ----NANO/ProMicro--------
  Serial.begin(9600);	 // opens serial port, sets data rate to 9600 bps
#endif																		// -------------------------
#if defined(__AVR_ATmega32U4__)						// ----ProMicro-------------
  for(int i=0;i<100;i++){
    if(Serial){SerialFlag=0; break;}
    delay(10);
  }
//while(!Serial);
#elif defined(ESP8266)										// ----ESP8266--------------
  for(int i=0;i<9;i++)for(int j=0;j<2;j++) BUTTON[i][j][0]='\0';
  for(int i=0;i<3;i++)for(int j=0;j<2;j++) SLIDER[i][j][0]='\0';
#endif																		// -------------------------
#if defined(I2C)													// ----I2C------------------
  Wire.begin();
  lcd.begin(16,2);     // 16文字×2行の液晶
#if defined(ESP8266)||defined(__SAMD21__)	// ----ESP8266/XIAO---------
  lcd.setContrast(35); // 0-63...10(5V), 35(3.3V), 45(3V)
#else																			// ----NANO/ProMicro--------
  lcd.setContrast(10); // 0-63...10(5V), 35(3.3V), 45(3V)
#endif																		// -------------------------
#endif																		// -------------------------
#if defined(VIDEO)												// ----VIDEO----------------
  // initialize the TV stuff, select font and clear the screen
#if defined(__SAMD21__)										// ----XIAO-----------------
	display.begin();
//  display.setFont(&TomThumb);
  display.setTextColor(WHITE,BLACK);
	display.fillScreen(BLACK);
	display.setCursor(0,0);
#else																			// -------------------------
  TV.begin(NTSC, SCREEN_W, SCREEN_H);
  TV.select_font(font4x6);
  TV.clear_screen();
#endif																		// -------------------------
#endif																		// -------------------------
#if defined(PIXEL)												// ----NEOPIXEL-------------
  pixels.begin(); pixels.show();
#endif																		// -------------------------
#ifdef KEYBOARD
  // setup the keyboard
  keyboard.begin(DataPin, IRQpin, PS2Keymap_Japanese); // Japanese Keyboard
#endif																		// -------------------------
}
